'Program name                   20017001.bas
'Program to measure speed of four wire resistance measurement with 2001
'and  7001.

CALL Initialize(21, 0)                            ' init as system controller
   CLS
R1$ = SPACE$(22)
R2$ = SPACE$(22)
R3$ = SPACE$(22)
'--- Reset 2001
'   CALL Send(16, "*RST", Gpib.status%)             '*RST = Reset 2001
'--- Reset 7001
'   CALL Send(7, "*RST", Gpib.status%)                  '*RST = Reset 7001
'--- Configure 2001 for 4 wire resistance
REM***********************************************************************
   CALL Send(16, "INIT:CONT off", Gpib.Status%)
   CALL Send(16, "abort", Gpib.Status%)
   CALL Send(16, ":SENS:FUNC 'FRES'", Gpib.Status%)     'Set four wire ohms
   CALL Send(16, ":SENS:FRES:RANG 200", Gpib.Status%)   'Set ohms RANGE
   CALL Send(16, ":ARM:LAY1:sour imm;COUN 1;TCON:DIR ACC", Gpib.Status%) 'ARM Trig
   CALL Send(16, ":ARM:LAY2:SOUR IMM;DEL 0;COUN INF;TCON:DIR ACC", Gpib.Status%)
   CALL Send(16, ":TRIG:SEQ1:SOUR TLIN", Gpib.Status%)
   CALL Send(16, ":TRIG:SEQ1:COUN INF;DEL 0;TCON:DIR ACC;ASYN:ILIN 2;OLIN 1", Gpib.Status%)
REM***********************************************************************  
   CALL Send(7, "INIT:CONT off", Gpib.Status%)
   CALL Send(7, "abort", Gpib.Status%)
   CALL Send(7, ":ARM:LAY1:sour EXT;COUN 1;TCON:DIR SOUR", Gpib.Status%) '
   CALL Send(7, ":ARM:LAY2:SOUR IMM;COUN 1;TCON:DIR ACC", Gpib.Status%)
   CALL Send(7, ":TRIG:SEQ1:SOUR TLIN", Gpib.Status%)
   CALL Send(7, ":TRIG:SEQ1:COUN:AUTO ON", Gpib.Status%)
   CALL Send(7, ":TRIG:SEQ1:TCON:PROT ASYN;DIR sour;ASYN:ILIN 1;OLIN 2", Gpib.Status%)
REM*************************************************************************
   CALL Send(8, "INIT:CONT off", Gpib.Status%)
   CALL Send(8, "abort", Gpib.Status%)
   CALL Send(8, ":ARM:LAY1:sour EXT;COUN 1;TCON:DIR SOUR", Gpib.Status%) '
   CALL Send(8, ":ARM:LAY2:SOUR ext;COUN 1;TCON:DIR ACC", Gpib.Status%)
   CALL Send(8, ":TRIG:SEQ1:SOUR TLIN", Gpib.Status%)
   CALL Send(8, ":TRIG:SEQ1:COUN:AUTO ON", Gpib.Status%)
   CALL Send(8, ":TRIG:SEQ1:TCON:PROT ASYN;DIR acc;ASYN:ILIN 1;OLIN 2", Gpib.Status%)
REM*************************************************************************
   CALL Send(9, "INIT:CONT off", Gpib.Status%)
   CALL Send(9, "abort", Gpib.Status%)
   CALL Send(9, ":ARM:LAY1:sour EXT;COUN 1;TCON:DIR SOUR", Gpib.Status%) '
   CALL Send(9, ":ARM:LAY2:SOUR ext;COUN 1;TCON:DIR ACC", Gpib.Status%)
   CALL Send(9, ":TRIG:SEQ1:SOUR TLIN", Gpib.Status%)
   CALL Send(9, ":TRIG:SEQ1:COUN:AUTO ON", Gpib.Status%)
   CALL Send(9, ":TRIG:SEQ1:TCON:PROT ASYN;DIR acc;ASYN:ILIN 1;OLIN 2", Gpib.Status%)
REM*************************************************************************
   CALL Send(7, ":OPEN all", Gpib.Status%)              'Open ALL channels
   CALL Send(8, ":OPEN all", Gpib.Status%)              'Open ALL channels
   CALL Send(9, ":OPEN all", Gpib.Status%)              'Open ALL channels
REM************************************************************************
REM** Start the trigger by sending IMMediate to 2001
   CALL Send(16, ":ARM:LAY1:imm", Gpib.Status%)'ARM Trig

'--- Read 2001
   CALL Send(16, ":SENS:DATA?", Gpib.Status%)           'Query for reading
   CALL Enter(R2$, Gpib.len%, 16, Gpib.Status%)
   R2$ = LEFT$(R2$, Gpib.len%)
   PRINT "R2 = "; R2$
   CALL Send(7, ":OPEN all", Gpib.Status%)               'Open ALL channels
   CALL Send(7, ":CLOS (@1!2,1!12)", Gpib.Status%)       'Close channel 2&12
    FOR I = 1 TO 10000: NEXT I
'--- Read 2001
   CALL Send(16, ":SENS:DATA?", Gpib.Status%)           'Query for reading
   CALL Enter(R1$, Gpib.len%, 16, Gpib.Status%)
   R1$ = LEFT$(R1$, Gpib.len%)
   PRINT "R1 = "; R1$
   CALL Send(7, ":OPEN (@1!12)", Gpib.Status%)               'Open ALL channels
    CALL Send(7, ":CLOS (@1!11)", Gpib.Status%)       'Close channel 11
    FOR I = 1 TO 10000: NEXT I
'--- Read 2001
   CALL Send(16, ":SENS:DATA?", Gpib.Status%)           'Query for reading
   CALL Enter(R3$, Gpib.len%, 16, Gpib.Status%)
   R3$ = LEFT$(R3$, Gpib.len%)
   PRINT "R3 = "; R3$
END


